#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
using namespace std;

int min_substr_length(const string& s)
{
	int n = s.length();
	int i = 0, j = n - 1;
	// find first position where string starts not being a palindrome
	while (i < j)
	{
		if (s[i] - 'a' != s[j] - 'a') break;
		i++; j--;
	}
	vector<int> char_cnt_left(26);
	vector<int> char_cnt_right(26);

	int length = 0;
	while (i <= j)
	{
		int curr_char_right = s[j] - 'a';
		char_cnt_right[curr_char_right]++;
		while (i <= j && char_cnt_right[curr_char_right] > char_cnt_left[curr_char_right])
		{
			int curr_char_left = s[i++] - 'a';
			char_cnt_left[curr_char_left]++;
			length++;
		}
		j--;
		if (i == n - 1 - j) break;
	}

	return length;
}

int main()
{
	string s; cin >> s;
	int n = s.length();

	int min_substr_left = min_substr_length(s);
	reverse(s.begin(), s.end());
	int min_substr_right = min_substr_length(s);

	cout << max(min(min_substr_left, min_substr_right), 1) << endl;
	return 0;
}